<?xml version="1.0" encoding="ISO-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.w3.org/1999/xhtml">
  <xsl:output method="html" />
  <xsl:template match="/event">
    <html>
      <head>
        <link rel="Stylesheet" href="trailtime.css" />
        <title><xsl:value-of select="header/title" /></title>
      </head>
      <body>
	<div id="header">
        <span class="event_title"><xsl:value-of select="header/title" /></span>
        <span class="event_date"><xsl:value-of select="header/date" /></span>

<xsl:comment> --- loop thru all series that we are a part of </xsl:comment>

        <xsl:for-each select="header/series">
          <xsl:if test="position()&gt;1">
            <span class="series_title_other"><xsl:value-of select="." /></span>
	  </xsl:if>
          <xsl:if test="position()= 1">
            <span class="series_title_main"><xsl:value-of select="." /></span>
	  </xsl:if>
        </xsl:for-each>
	</div>
<xsl:comment> ---------------------------------------- </xsl:comment>
<xsl:comment>                 main table               </xsl:comment>
<xsl:comment> ---------------------------------------- </xsl:comment>

        <table>
          <tr>
            <th>Description</th>
            <th>Distance</th>
            <th>Time</th>
            <th>Avg Speed</th>
            <th>Check</th>
            <th>Opens...</th>
            <th>..at</th>
          </tr>

<xsl:comment> --- for each check block.... --- </xsl:comment>

          <xsl:for-each select="checks/check">
          <tr>

<xsl:comment> --- description can contain TT and warning info --- </xsl:comment>

            <td class="description">
              <xsl:for-each select="description/tt">
		<xsl:if test="position()&gt;1">
		  &amp;
		</xsl:if>
                <span class="TT">TT <xsl:value-of select="." /></span>
              </xsl:for-each>
              <span class="terrain"><xsl:value-of select="description/general" /></span>
              <xsl:for-each select="description/warning">
                <span class="warning">NOTE: <xsl:value-of select="." /></span>
              </xsl:for-each>
            </td>

<xsl:comment> --- for the START line don't want to print.... --- </xsl:comment>

            <xsl:choose>
              <xsl:when test="position()&gt;1">
                <td class="distance"><xsl:value-of select="distance" /> km</td>
                <td class="time"><xsl:value-of select="time" /> min</td>
                <td class="average"><xsl:value-of select="average" /> kph</td>
              </xsl:when>
              <xsl:otherwise>
                <td />
                <td />
                <td />
              </xsl:otherwise>
            </xsl:choose>


<xsl:comment> --- Fuel check may go before or after Check --- </xsl:comment>

            <td class="check">
              <xsl:if test="position()&gt;1">
                <xsl:choose>
                  <xsl:when test="fuel[@position=&apos;before&apos;]">
                    <div class="fuel">Fuel <xsl:value-of select="fuel" /></div>
                  </xsl:when>
                  <xsl:otherwise><div class="no_fuel" /></xsl:otherwise>
                </xsl:choose>
              </xsl:if>
              <xsl:value-of select="number" />
              <xsl:if test="position()&gt;1">
                <xsl:choose>
                  <xsl:when test="fuel[@position=&apos;after&apos;]">
                    <div class="fuel">Fuel
                      <xsl:value-of select="fuel" />
                    </div>
                  </xsl:when>
                  <xsl:otherwise>
                    <div class="no_fuel" />
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:if>
            </td>

<xsl:comment> --- Open time and location of check --- </xsl:comment>

            <td class="opens"><xsl:value-of select="open" /></td>
            <td class="location"><xsl:value-of select="location" /></td>
          </tr>

<xsl:comment> --- If check is a finish, add a subtotal line --- </xsl:comment>

        <xsl:if test="finish">
          <tr>
            <td class="total"><span style="margin-right:1em">Total:</span></td>
            <td class="subtotal">
              <xsl:value-of select="finish/distance" /> km
            </td>
            <td class="subtotal"><xsl:value-of select="finish/time" /></td>
            <td colspan="4" class="finish">
              <xsl:value-of select="finish/grade" /> FINISH
            </td>
          </tr>
          </xsl:if>
          </xsl:for-each>
        </table>

	<xsl:comment> ---------------------------------------- </xsl:comment>
	<xsl:comment> Some footnotes on the bottom of the page </xsl:comment>
	<xsl:comment> ---------------------------------------- </xsl:comment>
	<div id="footer">
	  <span id="note">Notes:</span>
	  <xsl:comment> --- Fuel Locations --- </xsl:comment>
	  
	  <span id="fuel_locations">
	    <table>
	      <xsl:for-each select="/event/fuel-location">
		<tr>
		  <td class="identifier">
		    <span class="fuel">Fuel <xsl:value-of select="fuel" /></span>
		  </td>
		  <td><xsl:value-of select="location" /></td>
		</tr>
	      </xsl:for-each>
	    </table>
	  </span>
	  
	  <xsl:comment> --- TT Locations --- </xsl:comment>
	  <span id="tt_locations">
	    <table>
	      <xsl:for-each select="/event/tt-location">
		<tr>
		  <td class="identifier">
		    <xsl:for-each select="tt">
		      <xsl:if test="position()&gt;1">
			&amp;
		      </xsl:if>
		      <span class="TT">TT <xsl:value-of select="." /></span>
		    </xsl:for-each>
		  </td>
		  <td><xsl:value-of select="location" /></td>
		</tr>
	      </xsl:for-each>
	    </table>
	  </span>
	</div>
	<div id="logo"></div>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
